/* AUF24:*/
is_predicate(erreicht_db,2).

dic(ha,k,463).
dic(ha,fu,431).
dic(k,ka,325).
dic(k,ma,185).
dic(fr,m,434).
dic(fr,st,207).
dic(fu,m,394).
dic(ma,fr,38).
dic(ka,st,91).
dic(st,m,240).

dic_sym(Von,Nach,Dist):-dic(Von,Nach,Dist).
dic_sym(Von,Nach,Dist):-dic(Nach,Von,Dist).

ic(Von,Nach,Gesamt,Gesamt,_,Dist):-dic_sym(Von,Nach,Dist).
ic(Von,Nach,Basisliste,Ergebnis,Erreicht,Dist):-
       dic_sym(Von,Z,Dist1),
       not(element(Z,Erreicht)),
       ic(Z,Nach,[Z|Basisliste],Ergebnis,[Z|Erreicht],Dist2),
       Dist is Dist1+Dist2.

umkehre([],[]).
umkehre([Kopf|Rumpf],Ergebnis):-
       umkehre(Rumpf,Vorder_Liste),
       anfge(Vorder_Liste,[Kopf],Ergebnis).

anfge([],Hinter_Liste,Hinter_Liste).
anfge([Kopf|Rumpf],Hinter_Liste,[Kopf|Ergebnis]):-
       anfge(Rumpf,Hinter_Liste,Ergebnis).

filtern(Von,Nach,Liste_1,Liste_2):-
	     filtern_Von(Von,Liste_1,Liste_zwi),
	     filtern_Nach(Nach,Liste_zwi,Liste_2).

filtern_Von(Von,Liste_1,Liste_1):-
	     not(element(Von,Liste_1)).
filtern_Von(Von,Liste_1,Liste_2):-
	     abtrenne(Von,Liste_1,Liste_2).

filtern_Nach(Nach,Liste_1,Liste_1):-
	     not(element(Nach,Liste_1)).          
filtern_Nach(Nach,Liste_1,Liste_2):-
	     umkehre(Liste_1,Liste_1_invers),
	     abtrenne(Nach,Liste_1_invers,Liste_2_invers),
	     umkehre(Liste_2_invers,Liste_2).

abtrenne(Schnitt,[Schnitt|_],[]).
abtrenne(Schnitt,[Kopf|Rumpf],[Kopf|Rest]):-
	    abtrenne(Schnitt,Rumpf,Rest).

anforderung:-anfrage(Von,Nach),
	     !,
	     dic_frage(Von,Nach),
	     !,
	     antwort(Von,Nach,Dist,Resultat_invers),
	     vergleich(Dist,Resultat_invers),
            fail.

anfrage(Von,Nach):-write('Gib Abfahrtsort:'),nl,
	 ttyread(Von),
	 write('Gib Ankunftsort:'),nl,
	 ttyread(Nach),
	 not(gleich(Von,Nach)).

gleich(X,X):-write('Abfahrtsort gleich Ankunftsort'),nl.

dic_frage(Von,Nach):-not(dic_sym(Von,Nach,_)).
dic_frage(Von,Nach):-dic_sym(Von,Nach,Dist),
	      asserta(erreicht_db(Dist,[])),fail.

antwort(Von,Nach,Dist,Resultat_invers):-
	ic(Von,Nach,[],Resultat_Vorab,[],Dist),
	filtern(Von,Nach,Resultat_Vorab,Resultat),
	umkehre(Resultat,Resultat_invers).

vergleich(Dist,Resultat_invers):-
	      erreicht_db(Abstand,Liste),
	      Dist<Abstand,
	      retract(erreicht_db(Abstand,Liste)),
	      asserta(erreicht_db(Dist,Resultat_invers)).
vergleich(Dist,Resultat_invers):-
	      not(erreicht_db(_,_)),
	      asserta(erreicht_db(Dist,Resultat_invers)).

anzeige:-not(erreicht_db(_,_)),
	 write('IC-Verbindung existiert nicht'),nl.
anzeige:-erreicht_db(Abstand,Liste),
	 write('IC-Verbindung existiert'),nl,
	 write('Abstand:'),write(Abstand),nl,
	 not(Liste = []),
	 write('Zwischenstationen:'),nl,
	 ausgabe_listenelemente(Liste),nl.

ausgabe_listenelemente([]).
ausgabe_listenelemente([Kopf|Rumpf]):-
	 write(Kopf),nl,
	 ausgabe_listenelemente(Rumpf).

element(Wert,[Wert|_]).
element(Wert,[_|Rumpf]):-element(Wert,Rumpf).

bereinige_wiba:-retract(erreicht_db(_,_)),fail.
bereinige_wiba.         

start:-anforderung.
start:-anzeige.

auskunft:-bereinige_wiba,!,start.

